create or replace package tbicds.PCK_RPT_CDE
AUTHID CURRENT_USER 
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   -- Public constant declarations
   c_vEncrytedCdeIDs           constant varchar2(256) := 'C00007,C00035';
   c_nShowLatestIntake         constant number(1) := 0;
   c_nIncludeNoIntake          constant number(1) := 0;
   
   -- getPatientCdeValue
   procedure getPatientCdeValue (
      pi_vPatientID                     in varchar2,
      pi_vCdeID                         in varchar2,
      pi_nIntakeID                      in number,
      pi_vKey                           in varchar2,
      po_vValue                        out varchar2
      );

   -- setPatientCde
   procedure setPatientCde (
      pi_vPatientID                     in varchar2 default null
      );

   -- tblPatientCde
   function tblPatientCde (
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_dDateRange_Start               in date,
      pi_dDateRange_End                 in date
      ) return                             typ_tbl_rpt_cde_pat pipelined;

   -- tblPatientCde_Cached: use patient_cde table
   function tblPatientCde_Cached (
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_dDateRange_Start               in date,
      pi_dDateRange_End                 in date
      ) return                             typ_tbl_rpt_cde_pat pipelined;

   -- GetPatientCdeRS
   procedure GetPatientCdeRS (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      --pi_nReportID                      in number,
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_vDateRange_Start               in varchar2,
      pi_vDateRange_End                 in varchar2,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2,
      rs                               out sys_refcursor
      );

   -- GetPatientCdeRS_Cached
   procedure GetPatientCdeRS_Cached (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      --pi_nReportID                      in number,
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_vDateRange_Start               in varchar2,
      pi_vDateRange_End                 in varchar2,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2,
      rs                               out sys_refcursor
      );

end;
/

